<?php
header("Content-Type: application/json; charset=UTF-8");

// ------------------------------
// 🔐 CONFIGURACIÓN DE CONTRASEÑA
// ------------------------------
$ADMIN_PASSWORD = "Emperador2025+";

// ------------------------------
// 🔒 SOLO PERMITIR POST
// ------------------------------
if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    echo json_encode([
        "ok" => false,
        "error" => "Método no permitido."
    ]);
    exit;
}

// ------------------------------
// 📥 LEER JSON ENVIADO DESDE JS
// ------------------------------
$input = json_decode(file_get_contents("php://input"), true);

if (!$input || !isset($input["password"])) {
    echo json_encode([
        "ok" => false,
        "error" => "Datos incompletos."
    ]);
    exit;
}

// ------------------------------
// 🔐 VALIDAR CONTRASEÑA
// ------------------------------
if ($input["password"] !== $ADMIN_PASSWORD) {
    echo json_encode([
        "ok" => false,
        "error" => "Contraseña incorrecta."
    ]);
    exit;
}

// ------------------------------
// 📁 ARCHIVO JSON DESTINO
// ------------------------------
$file = "estado_cartones.json";

// Estado base
$estadoActual = [
    "vendidos"   => [],
    "reservados" => [],
    "ventas"     => []
];

// Si ya existe el JSON, lo cargamos para no perder info
if (file_exists($file)) {
    $contenido = json_decode(file_get_contents($file), true);
    if (is_array($contenido)) {
        $estadoActual = array_merge($estadoActual, $contenido);
    }
}

// ------------------------------
// 🧮 ACTUALIZAR VENDIDOS / RESERVADOS
// ------------------------------
if (isset($input["vendidos"]) && is_array($input["vendidos"])) {
    $estadoActual["vendidos"] = array_values(
        array_unique(array_map("intval", $input["vendidos"]))
    );
}

if (isset($input["reservados"]) && is_array($input["reservados"])) {
    $estadoActual["reservados"] = array_values(
        array_unique(array_map("intval", $input["reservados"]))
    );
}

// ------------------------------
// 🧾 ACTUALIZAR / AGREGAR VENTAS
// ------------------------------
// Esperamos un array de ventas completo desde el frontend
if (isset($input["ventas"]) && is_array($input["ventas"])) {
    $ventasLimpias = [];

    foreach ($input["ventas"] as $venta) {
        if (!is_array($venta)) continue;

        $fecha    = isset($venta["fecha"]) ? (string)$venta["fecha"] : "";
        $nombre   = isset($venta["nombre"]) ? (string)$venta["nombre"] : "";
        $telefono = isset($venta["telefono"]) ? (string)$venta["telefono"] : "";
        $cartones = [];

        if (isset($venta["cartones"]) && is_array($venta["cartones"])) {
            foreach ($venta["cartones"] as $c) {
                $cartones[] = intval($c);
            }
        }

        $cantidad = isset($venta["cantidad"]) ? intval($venta["cantidad"]) : count($cartones);
        $total_bs = isset($venta["total_bs"]) ? floatval($venta["total_bs"]) : 0;

        $ventasLimpias[] = [
            "fecha"    => $fecha,
            "nombre"   => $nombre,
            "telefono" => $telefono,
            "cartones" => $cartones,
            "cantidad" => $cantidad,
            "total_bs" => $total_bs
        ];
    }

    $estadoActual["ventas"] = $ventasLimpias;
}

// ------------------------------
// ✍ GUARDAR NUEVOS DATOS
// ------------------------------
$guardado = file_put_contents($file, json_encode($estadoActual, JSON_PRETTY_PRINT));

if ($guardado === false) {
    echo json_encode([
        "ok" => false,
        "error" => "No se pudo guardar el archivo JSON."
    ]);
    exit;
}

// ------------------------------
// 📤 RESPUESTA EXITOSA
// ------------------------------
echo json_encode([
    "ok"     => true,
    "estado" => $estadoActual
]);
?>
